function [f2, f1, kshift] = show_shift(kin, shift_pixels)
% shift ifft of kin by 'shift_pixels' pixels.
% ===============================================
f1 = ifftc(kin(:));
% shift_pixels = 2;
N = length(kin) - mod(length(kin), 2);
kin = kin(1:N);
kin_vec = -N/2:N/2 - 1;
% kin_vec = 0:N - 1;
kshift = kin(:).*exp(-2*pi*1i/N*kin_vec(:)*shift_pixels);
f2 = ifftc(kshift);

figure;
plot(real(f1), '-+');
hold on, plot(imag(f1), 'm-+'); grid on;
title(' before shift ');

figure;
plot(real(f2), '-+');
hold on, plot(imag(f2), 'm-+'); grid on;
title([' after shift by ', num2str(shift_pixels), '. ']);
